// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
|==========||==========|
GS Shader 2.1

By Goldshadow12
|==========||==========|
*/

// Original from Bicubic Shader by @bicubic7.

#include "uniformWorldConstants.h"
#include "uniformShaderConstants.h"
#include "fragmentVersionSimple.h"
#include "uniformPerFrameConstants.h"

#include "structure_function.h"
#include "noise_fbm.h"

in highp vec3 pos;
in vec4 color;

vec3 skyc(function m, Color n){
       vec3 scol = mix(vec3(.1,.3,.65), vec3(.15,.3,.5), m.sunfunc);
       scol = mix(scol, vec3(0.2, 0.4, 1.0)*0.1, m.nightfunc);
       scol = mix(scol*0.5,scol*1.5,scol);

vec3 gradcolor = mix(mix(vec3(1.1), vec3(.7,.6,.3), m.sunfunc), vec3(0.2,0.4,0.8)*0.4, m.nightfunc);

  vec3 col = mix(scol, n.fc.rgb*1.5, clamp(m.lp*0.9,0.,1.));
       col = mix(col, gradcolor, clamp(pow(m.lp,1.5)*1.0,0.,1.));
       col = mix(col, gradcolor, clamp(pow(m.lp,1.5)*1.1,0.,1.));
       col = mix(col, vec3(n.fc.rgb*1.8), m.rainfunc);
       col = mix(col, vec3(n.fc.r*1.4), clamp(m.lp*1.5,0.,1.)*m.rainfunc);
       col = mix(col, vec3(n.fc.rgb), clamp(pow(m.lp,1.5)*1.5,0.,1.)*m.rainfunc);

return col;
}

vec3 final_sky(function m, Color n){
    
    vec3 cloud_color = mix(mix(mix(n.nooncolor, n.suncolor, m.sunfunc), n.nightcolor, m.nightfunc), n.raincolor, m.rainfunc);
    
    float Inter = smoothstep(.0,1.,.03);
    
    highp float cm = fbm(pos.xz*10.,.002,mix(.35,.8,m.rainfunc),.05);
    highp float cm2 = fbm(pos.xz*9.3,.002,mix(.35,.8,m.rainfunc),.03);
    highp float base = min(.7,smoothstep(.0,.5,cm));
    
    vec3 coL = cloud_color-abs(cm2*.8);

    vec3 final = mix(skyc(m,n), coL, base*(1.-clamp(m.lp*1.7,.0,1.)));
    
    return final;
}

void main(){

vec4 fc = FOG_COLOR;
float cc = CURRENT_COLOR.r;

function m;
    m.nightfunc = pow(max(min(1.0-fc.r * 1.5, 1.0), 0.0), 1.2);
    m.sunfunc = pow(max(min(1.0-fc.b * 1.2, 1.0), 0.0), 0.5);
    m.rainfunc = (1.0-pow(FOG_CONTROL.y,5.0));
    m.lp = length(pos.xz);

Color n;
    n.nooncolor = vec3(1.2);
    n.suncolor = vec3(1.0,0.5,0.0)*1.2;
    n.nightcolor = vec3(0.25,0.6,0.8);
    n.raincolor = fc.rgb;
    n.fc = fc;

  vec3 res = final_sky(m, n);
  vec3 grayscale = vec3(res.r * 0.3 + res.g * 0.59 + res.b * 0.11);
           res = mix(res , grayscale, 0.1);

gl_FragColor = vec4(res,n.fc.a);
}